using System; 
using Server; 
using Server.Gumps; 
using Server.Network;
using Server.Items;
using Server.Mobiles;
using Server.Commands;

namespace Server.Gumps
{ 
   public class NorivarGump : Gump 
   { 
      public static void Initialize() 
      { 
         CommandSystem.Register( "NorivarGump", AccessLevel.GameMaster, new CommandEventHandler( NorivarGump_OnCommand ) ); 
      } 

      private static void NorivarGump_OnCommand( CommandEventArgs e ) 
      { 
         e.Mobile.SendGump( new NorivarGump( e.Mobile ) ); 
      } 

      public NorivarGump( Mobile owner ) : base( 50,50 ) 
      { 
//----------------------------------------------------------------------------------------------------

				AddPage( 0 );
			AddImageTiled(  54, 33, 369, 400, 2624 );
			AddAlphaRegion( 54, 33, 369, 400 );

			AddImageTiled( 416, 39, 44, 389, 203 );
//--------------------------------------Window size bar--------------------------------------------
			
			AddImage( 97, 49, 9005 );
			AddImageTiled( 58, 39, 29, 390, 10460 );
			AddImageTiled( 412, 37, 31, 389, 10460 );
			AddLabel( 140, 60, 0x34, "The Quest of Endless Peril" );
			

			AddHtml( 107, 140, 300, 230, "<BODY>" +
//----------------------/----------------------------------------------/
"<BASEFONT COLOR=YELLOW>*Norivar na tebe pohldl a usml se*...<BR><BR>Bu pozdraven cizine. Jsem kovsk velmistr Norivar..<BR>" +
"<BASEFONT COLOR=YELLOW>Ah, Vidm ze si prohl mj tt, tak bys chtl vlastnit jeden z tchto vzcnch kousk?<BR><BR>Mohl bych pro tebe jeden vyrobit. " +
"<BASEFONT COLOR=YELLOW>Umm ukovat vci nevdan, ale potebuji pro sv kovsk umn psady. Abych mohl ukovat tt s vlastnosmi jako m ten mj potebuji 35 kus Ancient Myrhu. Tuto vzcnou psadu najde jen u kon jmnem Dartmoor.<BR><BR>Na svt je ji jen velmi mlo tchto monster, kter vak nen snadn porazit. Chce li tento vzcn tt vlastnit, dozajista najde dost odvahy, aby si tyto kon vyhledal a psadu mi pinesl.<BR><BR>Peji ti hodn tst." +
						     "</BODY>", false, true);
			

			AddImage( 430, 9, 10441);
			AddImageTiled( 40, 38, 17, 391, 9263 );
			AddImage( 6, 25, 10421 );
			AddImage( 34, 12, 10420 );
			AddImageTiled( 94, 25, 342, 15, 10304 );
			AddImageTiled( 40, 427, 415, 16, 10304 );
			AddImage( -10, 314, 10402 );
			AddImage( 56, 150, 10411 );
			AddImage( 155, 120, 2103 );
			AddImage( 136, 84, 96 );

			AddButton( 225, 390, 0xF7, 0xF8, 0, GumpButtonType.Reply, 0 ); 

//--------------------------------------------------------------------------------------------------------------
      } 

      public override void OnResponse( NetState state, RelayInfo info ) //Function for GumpButtonType.Reply Buttons 
      { 
         Mobile from = state.Mobile; 

         switch ( info.ButtonID ) 
         { 
            case 0: //Case uses the ActionIDs defenied above. Case 0 defenies the actions for the button with the action id 0 
            { 
               //Cancel 
               from.SendMessage( "The Glory of the Church is behind you, if your faith is strong you shall not fail.  Safe Journies!" );
               break; 
            } 

         }
      }
   }
}
 
